Attribute VB_Name = "modEmployees"
Option Explicit

Function NextEmptyRow(ws As Worksheet) As Long
    NextEmptyRow = ws.Cells(ws.Rows.Count, "A").End(xlUp).Row + 1
End Function

Function GenerateNewEmpID() As String
    Dim ws As Worksheet
    Dim lastID As String
    Dim num As Long
    
    Set ws = ThisWorkbook.Sheets("EMPLOYEES")
    
    If ws.Cells(2, 1) = "" Then
        GenerateNewEmpID = "EMP001"
    Else
        lastID = ws.Cells(ws.Rows.Count, "A").End(xlUp).Value
        num = CLng(Mid(lastID, 4)) + 1
        GenerateNewEmpID = "EMP" & Format(num, "000")
    End If
End Function

Function FindEmployeeRow(empID As String) As Long
    Dim ws As Worksheet
    Dim f As Range
    
    Set ws = ThisWorkbook.Sheets("EMPLOYEES")
    
    Set f = ws.Columns("A").Find(empID, LookIn:=xlValues, LookAt:=xlWhole)
    
    If Not f Is Nothing Then
        FindEmployeeRow = f.Row
    Else
        FindEmployeeRow = 0
    End If
End Function

